const moment = require('moment');

class RankingDatabase{
  constructor(db){
    this.db = db;

    let defaults = { 
      rankings: []
    };

    this.db.defaults(defaults).write();

  }

  /** Public Methods */
  firstRecordedItem(type){
    let item = this.db.get('rankings[0]');
    if(!item.size().value()){
      return null;
    }

    return item.value();
  }

  getLastRanking(appID, type){
    let now = moment().format('YYYY-DD-MM');
    
    //Get the current price value
    let currentRanking = this._existingItemWithDate(now);
    if(!currentRanking){
      return null;
    }

    currentRanking = currentRanking.value();

    //Find the last price change
    let lastChange = this.db.get('rankings')
    .orderBy('date', 'desc')
    .find(function(obj){
      //Ignore any null/invalid prices
      if(!obj[type] || obj.appID != appID){
        return false;
      }

      return obj[type] !== currentRanking[type];
    });

    if(!lastChange.size().value()){
      return null;
    }

    return lastChange.value();
  }

  add(appID, obj){
    if(!obj){
      return false;
    }

    obj = Object.assign({}, obj);


    let now = moment().format('YYYY-DD-MM');
    obj.date = now;
    obj.appID = appID;

    let existingItem = this._existingItemWithDate(now);

    //Update the price of the existing item if there is one
    if(existingItem){
      existingItem.assign(obj).write();
    }
    else{
      //Add the new line
      this.db.get('rankings').push(obj).write();
    }

    return true;
  }

  _existingItemWithDate(date){
    let elem = this.db.get('rankings').find(function(obj){
      return obj.date == date;
    });

    if(!elem.size().value()){
      return null;
    }

    return elem;
  }

};

module.exports = RankingDatabase;